<?php
require_once "../config/config.php";
session_start();
require_once "../includes/role_helpers.php";
requireAdmin();

$dbHost = DB_HOST;
$dbUser = DB_USER;
$dbPass = DB_PASS;
$dbName = DB_NAME;

$backupFolder = __DIR__ . '/backups/';
if (!is_dir($backupFolder)) {
    mkdir($backupFolder, 0755, true);
}

$message = '';

if (isset($_POST['backup_now'])) {
    $backupFile = $backupFolder . $dbName . '_' . date('Ymd_His') . '.sql';

    $command = "mysqldump --user={$dbUser} --password={$dbPass} --host={$dbHost} {$dbName} > {$backupFile}";

    exec($command, $output, $return_var);

    if ($return_var === 0) {
        $message = "Backup successful: " . basename($backupFile);
    } else {
        $message = "Backup failed.";
    }
}

// List existing backups
$backups = array_diff(scandir($backupFolder, SCANDIR_SORT_DESCENDING), ['.', '..']);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Database Backup - Adwenpa Pharma</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
</head>
<body>
<div class="container my-4">
    <h2>Database Backup</h2>

    <?php if ($message): ?>
    <div class="alert alert-info"><?= htmlspecialchars($message) ?></div>
    <?php endif; ?>

    <form method="post">
        <button type="submit" name="backup_now" class="btn btn-primary mb-3">Create Backup Now</button>
        <a href="dashboard.php" class="btn btn-secondary mb-3">Back to Dashboard</a>
    </form>

    <h4>Existing Backups</h4>
    <?php if (empty($backups)): ?>
        <p>No backups available.</p>
    <?php else: ?>
        <ul class="list-group">
            <?php foreach ($backups as $file): ?>
                <li class="list-group-item d-flex justify-content-between align-items-center">
                    <?= htmlspecialchars($file) ?>
                    <a href="backups/<?= rawurlencode($file) ?>" class="btn btn-sm btn-outline-primary" download>Download</a>
                </li>
            <?php endforeach; ?>
        </ul>
    <?php endif; ?>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
